/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.busmon.parser.DisplayPort;

import com.quantumdata.busmon.parser.DisplayPort.DisplayPortDataBlock;
import com.quantumdata.busmon.parser.DisplayPort.DisplayPortMessage;

public class DisplayPortReplyMessage
extends DisplayPortMessage {
    public DisplayPortReplyMessage(int n, byte[] byArray) {
        super(n, byArray);
    }

    public String getDetails() {
        StringBuffer stringBuffer = new StringBuffer("");
        byte[] byArray = this.getData();
        if (byArray == null) {
            return stringBuffer.toString();
        }
        if (!this.isNative()) {
            return stringBuffer.toString();
        }
        int n = DisplayPortDataBlock.lastBlockAddress();
        stringBuffer.append("Display Port Message Details\n");
        stringBuffer.append("----------------------------\n\n");
        if (DisplayPortDataBlock.addressBlockIsReserved(n)) {
            stringBuffer.append("DisplayPort Address " + DisplayPortDataBlock.longAddressToHexString(n) + " is RESERVED\n");
        } else if (DisplayPortDataBlock.addressIsHDCPBlock(n)) {
            for (int i = 0; i < byArray.length; ++i) {
                stringBuffer.append(DisplayPortDataBlock.getHDCPData(n, byArray[i]));
                ++n;
            }
        } else {
            for (int i = 0; i < byArray.length; ++i) {
                stringBuffer.append(DisplayPortDataBlock.getContentData(n, byArray[i]));
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    public String getSummary() {
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.getMessageType()) {
            case 6: {
                if (this.getDataLength() > 0) {
                    byte[] byArray = this.getData();
                    stringBuffer.append("AUX ACK [");
                    for (int i = 0; i < this.getDataLength(); ++i) {
                        stringBuffer.append(String.format(" 0x%1$02X", byArray[i]));
                    }
                    stringBuffer.append(" ]");
                    break;
                }
                stringBuffer.append("AUX ACK");
                break;
            }
            case 8: {
                stringBuffer.append("AUX DEFER");
                break;
            }
            case 7: {
                if (this.getDataLength() > 0) {
                    byte[] byArray = this.getData();
                    stringBuffer.append("AUX NACK [");
                    for (int i = 0; i < this.getDataLength(); ++i) {
                        stringBuffer.append(String.format(" 0x%1$02X", byArray[i]));
                    }
                    stringBuffer.append(" ]");
                    break;
                }
                stringBuffer.append("AUX NACK");
                break;
            }
            case 9: {
                if (this.getDataLength() > 0) {
                    byte[] byArray = this.getData();
                    stringBuffer.append("I2C ACK ");
                    for (int i = 0; i < this.getDataLength(); ++i) {
                        stringBuffer.append(String.format(" 0x%1$02X", byArray[i]));
                    }
                    break;
                }
                stringBuffer.append("I2C ACK");
                break;
            }
            case 10: {
                if (this.getDataLength() > 0) {
                    byte[] byArray = this.getData();
                    stringBuffer.append("I2C NACK ( M=");
                    for (int i = 0; i < this.getDataLength(); ++i) {
                        stringBuffer.append(String.format("%1$d", byArray[i]));
                    }
                    stringBuffer.append(" BYTES WRITTEN )");
                    break;
                }
                stringBuffer.append("I2C NACK");
                break;
            }
            case 11: {
                stringBuffer.append("I2C DEFER");
            }
        }
        return stringBuffer.toString();
    }

    public String getMessageTypeText() {
        return null;
    }

    public int getDataLength() {
        byte[] byArray = this.getData();
        if (byArray == null) {
            return 0;
        }
        return byArray.length;
    }

    public boolean isMotSet() {
        return false;
    }

    public int getAddress() {
        return 0;
    }

    public String getDirection() {
        return "REPLY";
    }

    public boolean isEvent() {
        return false;
    }

    public boolean isI2C() {
        return !this.isNative();
    }

    public boolean isHDCP() {
        return DisplayPortDataBlock.addressIsHDCPBlock(this.getAddress());
    }

    public boolean isDDCCI() {
        return this.getAddress() == 110 && this.isI2C();
    }

    public boolean isEDID() {
        return this.isI2C() && (this.getAddress() == 160 || this.getAddress() == 96);
    }

    public boolean isLT() {
        return this.isNative() && DisplayPortDataBlock.addressIsLT(DisplayPortDataBlock.lastBlockAddress());
    }
}

